/*
 * extract.h
 */

#define TAGBUFSIZE          (24*1024)

//@enum Types of comments recognized by Autoduck.

enum COMMENTTYPES
{
    commentSingleChar = 1,  //@emem Assembly comment.
    commentSlashstar,       //@emem Multiline C/C++ comment.
    commentSlashslash,      //@emem Single line C++ comment.
};


class CPendingTag
{
public:
	int  nParseType;
	int  nPendingFields;
	BOOL bTopic;

	CTag *ptag;
	CTag *ptagParent;
	CPendingTag(void) { nParseType = nPendingFields = bTopic = 0; ptag = ptagParent = NULL; }
};

typedef CTypedPtrList<CPtrList, CPendingTag *> CPendingList;

class CSrcText
{
public:
	long m_lSrcLine;
	CString m_sText;
};

typedef CTypedPtrList<CPtrList, CSrcText *> CSrcTextList;


// @class Source declaration which we are saving for parsing.
class CSrcDecl
{
public:
	CString m_sSrcText;
	long    m_lSrcLine;

	CSrcDecl(void) { m_lSrcLine = 0; }
	CSrcDecl(const char *szSrc, int nLen, long lSrcLine) : m_sSrcText(szSrc, nLen), m_lSrcLine(lSrcLine) {};
};


// @class Object for managing a list of source declarations
class CSrcDeclList
{
public:
	CTypedPtrList<CPtrList, CSrcDecl *> m_lDecls;

	CSrcDecl *Get(long lSrcLine);
	CSrcDecl *Add(const char *szSrc, int nLen, long lSrcLine);
	void Empty(void);

	~CSrcDeclList();
};


//@class Source input file and state

class CSrcInput : public CAdInput
{
public:
    char m_achTagBuf[TAGBUFSIZE+1];         // @cmember Stores tag text
    char *m_szTagCur;						// @cmember Next position within
	const char *m_szParseCur;				// @cmember Current parsing position
    int m_nSourceType;                      // @cmember Type of source file, defined in <e SOURCETYPES>.
	char m_chCommentDelim;					// @cmember One-character comment delim for non-C++ lang types
    int m_nLineTag;                         // @cmember Offset from topic line to tag start.
	int m_nFile;							// @cmember Index of input file
    enum CommentTypes
    {
        commentSemicolon,
        commentSlashStart,
        commentApostrophe,
        commentSlashSlash,
    };

    int m_nCommentType;

    struct SrcInputState
    {
        unsigned Comment : 1;
        unsigned BeginComment : 1;
        unsigned EndComment : 1;
        unsigned Autoduck : 1;
        unsigned Topic : 1;
        unsigned HaveTopicTag : 1;
        unsigned Tag : 1;
        unsigned GrowingTag : 1;
        unsigned NestedTopic : 1;
        unsigned MultilineSourceline : 1;
		unsigned PendingTopic : 1;
		unsigned SkipTopic : 1;
		unsigned SkipAux : 1;
        unsigned AuxTopicOpen : 1;
		unsigned AuxTopicTag : 1;
		unsigned AuxPara : 1;
		unsigned AuxParaTag : 1;
    } m_nState;

	CPendingList m_pendMain;		//@cmember Tags from the main topic
									// requiring source fields
	CPendingList m_pendAux;			//@cmember Tags from aux topic requiring
									// source fields

    CString m_sTag;                 // @cmember Current tag - to be parsed next time.
									// <e EXTRACTINFO.szTagBuf>
    CString m_sTagAux;              // @cmember Topic tag to parse on top of regular tag
	CTagList m_listTags;			// @cmember Main topic tag list.
	CTagList m_listAuxTags;	        // @field Auxiliary topic tag list.
    CString m_sDocFlags;            // @field Current doc flags - always stored regardless
									// of whether they meet the extraction request.
	CString m_sLocalDocTag;			// @field Locally defined (topic-level) doc tag.

	CSrcDeclList m_lSrcDecl;	

public:
	void CueParse(CPendingList &m_pendMain, CTag *ptag, int nTargetFields, int nParseType, BOOL bTopic);
	void CueParse(CPendingList &pend, CTag *ptag, CTag *ptagParent, FormatInfo &fmt);
    void ResetState(void) { CAdInput::ResetState(); ZeroMem(&m_nState, sizeof(m_nState)); }
	void EmptyParse(void);
    CSrcInput();
	~CSrcInput();
};


void ExtractTopics(CFile &out, RUNOPTIONS &run, CTopicLog  &log, FormatInfo &fmt);
